<?php
require_once 'config/database.php';
require_once 'includes/header.php';

// --- ADDED: Generate a unique form submission token ---
if (empty($_SESSION['form_token'])) {
    $_SESSION['form_token'] = bin2hex(random_bytes(32));
}
$token = $_SESSION['form_token'];
// --- END: Token Generation ---

// Fetch fee heads for the dropdown
$fee_heads = $pdo->query("SELECT fee_head_id, head_name FROM fee_heads ORDER BY head_name")->fetchAll();

// Default values for "Add" mode
$fine = ['fine_id' => '', 'fine_name' => '', 'fee_head_id' => '', 'start_after_days' => 1, 'fine_type' => 'Fixed', 'fine_value' => '', 'recurring_period' => 'None'];
$form_action = 'add';
$page_title = 'Create New Fine Rule';

// Check for "Edit" mode
if (isset($_GET['id'])) {
    $stmt = $pdo->prepare("SELECT * FROM fines WHERE fine_id = ?");
    $stmt->execute([$_GET['id']]);
    $fine = $stmt->fetch();
    $form_action = 'edit';
    $page_title = 'Edit Fine Rule';
}
?>

<div class="content-header">
    <h1><?php echo $page_title; ?></h1>
    <a href="fines.php" class="btn">⬅️ Back to Fine Rules</a>
</div>

<div class="card">
    <div class="card-body">
        <form action="process_fine.php" method="POST" id="fine-rule-form">
            <input type="hidden" name="action" value="<?php echo $form_action; ?>">
            <input type="hidden" name="fine_id" value="<?php echo $fine['fine_id']; ?>">
            <!-- ADDED: Hidden token field -->
            <input type="hidden" name="form_token" value="<?php echo $token; ?>">

            <div class="form-group"><label for="fine_name">Rule Name</label><input type="text" name="fine_name" value="<?php echo htmlspecialchars($fine['fine_name']); ?>" required></div>
            <div class="form-group"><label for="fee_head_id">Apply to which Fee Head?</label>
                <select name="fee_head_id" required>
                    <option value="">-- Select Fee Head --</option>
                    <?php foreach($fee_heads as $head): ?>
                        <option value="<?php echo $head['fee_head_id']; ?>" <?php echo ($head['fee_head_id'] == $fine['fee_head_id']) ? 'selected' : ''; ?>><?php echo htmlspecialchars($head['head_name']); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="form-row">
                <div class="form-group"><label for="start_after_days">Start Fine After (Days from Due Date)</label><input type="number" name="start_after_days" value="<?php echo htmlspecialchars($fine['start_after_days']); ?>" required></div>
                <div class="form-group"><label for="fine_type">Fine Type</label><select name="fine_type"><option <?php echo ($fine['fine_type'] == 'Fixed') ? 'selected' : ''; ?>>Fixed</option><option <?php echo ($fine['fine_type'] == 'Percentage') ? 'selected' : ''; ?>>Percentage</option></select></div>
                <div class="form-group"><label for="fine_value">Value (Amount or %)</label><input type="number" step="0.01" name="fine_value" value="<?php echo htmlspecialchars($fine['fine_value']); ?>" required></div>
            </div>
            <div class="form-group">
                <label for="recurring_period">Fine Frequency</label>
                <select name="recurring_period">
                    <option value="None" <?php echo (($fine['recurring_period'] ?? 'None') == 'None') ? 'selected' : ''; ?>>One Time (Fixed)</option>
                    <option value="Daily" <?php echo (($fine['recurring_period'] ?? 'None') == 'Daily') ? 'selected' : ''; ?>>Recurring (Per Day)</option>
                </select>
            </div>
            <div class="form-footer"><button type="submit" class="btn btn-primary">Save Rule</button></div>
        </form>
    </div>
</div>

<!-- JavaScript to prevent double submission (good for user experience) -->
<script>
document.getElementById('fine-rule-form').addEventListener('submit', function() {
    const button = this.querySelector('button[type="submit"]');
    button.disabled = true;
    button.textContent = 'Saving...';
});
</script>

<?php require_once 'includes/footer.php'; ?>

