<?php
// We need to connect to the DB to get school details
require_once 'config/database.php';

// If user is already logged in, redirect them away from login page
if (isset($_SESSION['user_id'])) {
    header("Location: dashboard.php");
    exit();
}

// Fetch school details for branding
try {
    $settings = $pdo->query("SELECT setting_key, setting_value FROM settings WHERE setting_key IN ('school_name', 'school_logo')")
                    ->fetchAll(PDO::FETCH_KEY_PAIR);
    $school_name = $settings['school_name'] ?? 'Fee Management System';
    $school_logo = $settings['school_logo'] ?? '';
} catch (PDOException $e) {
    $school_name = 'Fee Management System';
    $school_logo = '';
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - <?php echo htmlspecialchars($school_name); ?></title>
    
    <!-- Modern Google Font -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    
    <style>
        :root {
            --primary-color: #3b82f6;
            --primary-hover: #2563eb;
            --bg-color-light: #f1f5f9;
            --text-color-dark: #1e293b;
            --text-color-light: #64748b;
            --card-bg-color: #ffffff;
            --border-color: #e2e8f0;
        }
        body {
            font-family: 'Inter', sans-serif;
            background-color: var(--bg-color-light);
            background-image: linear-gradient(to top right, #e0eafc, #cfdef3);
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
            color: var(--text-color-dark);
        }
        .login-card {
            background-color: var(--card-bg-color);
            padding: 40px;
            border-radius: 0.75rem;
            box-shadow: 0 10px 25px rgba(0,0,0,0.1);
            width: 100%;
            max-width: 400px;
            text-align: center;
        }
        .school-branding {
            margin-bottom: 25px;
        }
        .school-logo {
            max-height: 80px;
            margin-bottom: 15px;
        }
        .school-name {
            font-size: 1.5rem;
            font-weight: 600;
            margin: 0;
        }
        .login-title {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            font-size: 1.25rem;
            font-weight: 500;
            color: var(--text-color-light);
            margin-bottom: 25px;
        }
        .form-group {
            position: relative;
            margin-bottom: 20px;
            text-align: left;
        }
        .form-group .icon {
            position: absolute;
            left: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: var(--text-color-light);
        }
        .form-group input {
            width: 86%;
            padding: 12px 12px 12px 45px; /* Padded for icon */
            border: 1px solid var(--border-color);
            border-radius: 6px;
            font-size: 1rem;
            background-color: var(--bg-color-light);
            color: var(--text-color-dark);
        }
        .form-group input:focus {
            outline: none;
            border-color: var(--primary-color);
            box-shadow: 0 0 0 2px rgba(59, 130, 246, 0.3);
        }
        .btn {
            width: 100%;
            background-color: var(--primary-color);
            color: white;
            padding: 12px;
            border: none;
            border-radius: 6px;
            font-size: 1rem;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.2s;
        }
        .btn:hover {
            background-color: var(--primary-hover);
            transform: translateY(-1px);
        }
        .error-message {
            background-color: #fee2e2;
            color: #991b1b;
            border: 1px solid #fecaca;
            padding: 10px;
            border-radius: 6px;
            text-align: center;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="login-card">
        <div class="school-branding">
            <?php if (!empty($school_logo)): ?>
                <img src="public/images/<?php echo htmlspecialchars($school_logo); ?>" alt="School Logo" class="school-logo">
            <?php endif; ?>
            <h2 class="school-name"><?php echo htmlspecialchars($school_name); ?></h2>
        </div>
        
        <p class="login-title">
            <i data-feather="lock"></i>
            <span>System Login</span>
        </p>
        
        <?php
        if (isset($_GET['error'])) {
            echo '<div class="error-message">' . htmlspecialchars($_GET['error']) . '</div>';
        }
        ?>

        <form action="login_process.php" method="POST">
            <div class="form-group">
                <span class="icon"><i data-feather="user"></i></span>
                <input type="text" id="username" name="username" placeholder="Username" required>
            </div>
            <div class="form-group">
                <span class="icon"><i data-feather="key"></i></span>
                <input type="password" id="password" name="password" placeholder="Password" required>
            </div>
            <button type="submit" class="btn">Login</button>
        </form>
    </div>

    <!-- Feather Icons Script -->
    <script src="https://unpkg.com/feather-icons"></script>
    <script>
        feather.replace();
    </script>
</body>
</html>
