<?php
require_once 'config/database.php';

// Security: Only Admins can process user actions
if ($_SESSION['role'] !== 'Admin') {
    header("Location: dashboard.php"); exit();
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_POST['action'])) {
    header('Location: users.php'); exit();
}

$action = $_POST['action'];

try {
    switch ($action) {
        case 'add':
            if (empty($_POST['username']) || empty($_POST['password'])) {
                throw new Exception("Username and password are required for new users.");
            }
            $sql = "INSERT INTO users (full_name, username, role, password_hash) VALUES (?, ?, ?, ?)";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([
                trim($_POST['full_name']),
                trim($_POST['username']),
                $_POST['role'],
                password_hash($_POST['password'], PASSWORD_DEFAULT)
            ]);
            header("Location: users.php?success=User created successfully!");
            break;

        case 'edit':
            $user_id = $_POST['user_id'];
            if (empty($user_id)) throw new Exception("Invalid user ID.");

            if (!empty($_POST['password'])) {
                // If a new password is provided, update it
                $sql = "UPDATE users SET full_name = ?, username = ?, role = ?, password_hash = ? WHERE user_id = ?";
                $stmt = $pdo->prepare($sql);
                $stmt->execute([
                    trim($_POST['full_name']), trim($_POST['username']), $_POST['role'],
                    password_hash($_POST['password'], PASSWORD_DEFAULT), $user_id
                ]);
            } else {
                // If password is blank, don't update it
                $sql = "UPDATE users SET full_name = ?, username = ?, role = ? WHERE user_id = ?";
                $stmt = $pdo->prepare($sql);
                $stmt->execute([trim($_POST['full_name']), trim($_POST['username']), $_POST['role'], $user_id]);
            }
            header("Location: users.php?success=User updated successfully!");
            break;

        case 'toggle_status':
            $user_id = $_POST['user_id'];
            if (empty($user_id) || $_SESSION['user_id'] == $user_id) { // Safety check
                throw new Exception("Invalid action. You cannot change your own status.");
            }
            $new_status = ($_POST['current_status'] == 1) ? 0 : 1; // Flip the status
            $stmt = $pdo->prepare("UPDATE users SET is_active = ? WHERE user_id = ?");
            $stmt->execute([$new_status, $user_id]);
            header("Location: users.php?success=User status updated successfully.");
            break;
    }
} catch (Exception $e) {
    if ($e->getCode() == '23000') {
        $error_message = "A user with that username already exists.";
    } else {
        $error_message = "Operation failed: " . $e->getMessage();
    }
    header("Location: users.php?error=" . urlencode($error_message));
}
exit();
?>
