<?php
header('Content-Type: application/json');
require_once 'config/database.php';

$term = $_GET['term'] ?? '';

if (strlen($term) < 2) {
    echo json_encode([]);
    exit();
}

try {
    $stmt = $pdo->prepare("
        SELECT student_id, student_uid, full_name, guardian_contact 
        FROM students 
        WHERE (student_uid LIKE ? OR full_name LIKE ? OR guardian_contact LIKE ?) AND is_active = 1
        LIMIT 10
    ");
    $searchTerm = "%{$term}%";
    $stmt->execute([$searchTerm, $searchTerm, $searchTerm]);
    $students = $stmt->fetchAll();
    echo json_encode($students);
} catch (PDOException $e) {
    echo json_encode(['error' => 'Database error']);
}
?>