<?php
require_once 'config/database.php';
require_once 'includes/header.php';

// --- Security: Only Admins can access this page ---
if ($_SESSION['role'] !== 'Admin') {
    // Redirect non-admins to the dashboard
    header("Location: dashboard.php");
    exit();
}

try {
    $users = $pdo->query("SELECT user_id, username, full_name, role, is_active FROM users ORDER BY full_name ASC")->fetchAll();
} catch (PDOException $e) {
    die("Error: Could not fetch users. " . $e->getMessage());
}
?>

<div class="content-header">
    <h1>User Account Management</h1>
    <a href="user_form.php" class="btn btn-primary">Create New User</a>
</div>

<!-- Message Display Area -->
<?php if(isset($_GET['success'])): ?><div class="alert alert-success"><?php echo htmlspecialchars($_GET['success']); ?></div><?php endif; ?>
<?php if(isset($_GET['error'])): ?><div class="alert alert-danger"><?php echo htmlspecialchars($_GET['error']); ?></div><?php endif; ?>

<div class="card">
    <div class="card-body">
        <table class="data-table">
            <thead>
                <tr>
                    <th>Full Name</th>
                    <th>Username</th>
                    <th>Role</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($users as $user): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($user['full_name']); ?></td>
                        <td><?php echo htmlspecialchars($user['username']); ?></td>
                        <td><?php echo htmlspecialchars($user['role']); ?></td>
                        <td>
                            <span style="color: <?php echo $user['is_active'] ? '#28a745' : '#dc3545'; ?>; font-weight: bold;">
                                <?php echo $user['is_active'] ? 'Active' : 'Inactive'; ?>
                            </span>
                        </td>
                        <td>
                            <a href="user_form.php?id=<?php echo $user['user_id']; ?>" class="btn-action btn-edit">Edit</a>
                            <?php if ($_SESSION['user_id'] != $user['user_id']): // Prevent admin from deactivating themselves ?>
                                <form action="process_user.php" method="POST" style="display:inline;" onsubmit="return confirm('Are you sure you want to change this user\'s status?');">
                                    <input type="hidden" name="action" value="toggle_status">
                                    <input type="hidden" name="user_id" value="<?php echo $user['user_id']; ?>">
                                    <input type="hidden" name="current_status" value="<?php echo $user['is_active']; ?>">
                                    <button type="submit" class="btn-action <?php echo $user['is_active'] ? 'btn-delete' : 'btn-primary'; ?>">
                                        <?php echo $user['is_active'] ? 'Deactivate' : 'Activate'; ?>
                                    </button>
                                </form>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once 'includes/footer.php'; ?>
